/*
 * Decompiled with CFR 0.152.
 */
package emulator.util.file;

import emulator.util.file.FileInfo;
import emulator.util.file.FileInfoP00;
import emulator.util.file.FileInfoPcVic;
import emulator.util.file.FileInfoPrg;
import emulator.util.file.FileInfoRaw;
import emulator.util.file.FileInfoSid;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileHelper {
    public static final int FILE_FORMAT_UNKNOWN = 0;
    public static final int FILE_FORMAT_RAW = 1;
    public static final int FILE_FORMAT_PRG = 2;
    public static final int FILE_FORMAT_PCV = 3;
    public static final int FILE_FORMAT_S20 = 4;
    public static final int FILE_FORMAT_P00 = 5;
    public static final int FILE_FORMAT_CRT = 6;
    public static final int FILE_FORMAT_SID = 7;
    static final byte[] PCVIC_HEADER_MAGIC;
    static final byte[] S20_HEADER_MAGIC;
    static final byte[] P00_HEADER_MAGIC;
    static final byte[] CRT_HEADER_MAGIC;
    static final byte[] PSID_HEADER_MAGIC;
    static final byte[] RSID_HEADER_MAGIC;

    static {
        byte[] byArray = new byte[22];
        byArray[0] = 80;
        byArray[1] = 67;
        byArray[2] = 86;
        byArray[3] = 73;
        byArray[4] = 67;
        byArray[5] = 32;
        byArray[6] = 115;
        byArray[7] = 121;
        byArray[8] = 115;
        byArray[9] = 116;
        byArray[10] = 101;
        byArray[11] = 109;
        byArray[12] = 32;
        byArray[13] = 115;
        byArray[14] = 110;
        byArray[15] = 97;
        byArray[16] = 112;
        byArray[17] = 115;
        byArray[18] = 104;
        byArray[19] = 111;
        byArray[20] = 116;
        PCVIC_HEADER_MAGIC = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 86;
        byArray2[1] = 73;
        byArray2[2] = 67;
        byArray2[3] = 45;
        byArray2[4] = 50;
        byArray2[5] = 48;
        byArray2[6] = 32;
        byArray2[7] = 83;
        byArray2[8] = 78;
        byArray2[9] = 65;
        byArray2[10] = 80;
        byArray2[11] = 83;
        byArray2[12] = 72;
        byArray2[13] = 79;
        byArray2[14] = 84;
        S20_HEADER_MAGIC = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 67;
        byArray3[1] = 54;
        byArray3[2] = 52;
        byArray3[3] = 70;
        byArray3[4] = 105;
        byArray3[5] = 108;
        byArray3[6] = 101;
        P00_HEADER_MAGIC = byArray3;
        CRT_HEADER_MAGIC = new byte[]{67, 54, 52, 32, 67, 65, 82, 84, 82, 73, 68, 71, 69, 32, 32, 32};
        PSID_HEADER_MAGIC = new byte[]{80, 83, 73, 68};
        RSID_HEADER_MAGIC = new byte[]{82, 83, 73, 68};
    }

    public static int guessFileFormat(String file_name) {
        int file_format = 0;
        File file = new File(file_name);
        if (file.exists() && file.isFile()) {
            if (FileHelper.hasHeaderMagic(file, P00_HEADER_MAGIC)) {
                file_format = 5;
            } else if (FileHelper.hasHeaderMagic(file, PCVIC_HEADER_MAGIC)) {
                file_format = 3;
            } else if (FileHelper.hasHeaderMagic(file, S20_HEADER_MAGIC)) {
                file_format = 4;
            } else if (FileHelper.hasHeaderMagic(file, CRT_HEADER_MAGIC)) {
                file_format = 6;
            } else if (FileHelper.hasHeaderMagic(file, PSID_HEADER_MAGIC) || FileHelper.hasHeaderMagic(file, RSID_HEADER_MAGIC)) {
                file_format = 7;
            } else {
                file_format = 1;
                String extension = FileHelper.getFileExtension(file_name).toLowerCase();
                if (extension.equals("prg")) {
                    file_format = 2;
                } else if (extension.equals("rom") || extension.equals("crt")) {
                    file_format = FileHelper.checkRomFormat(file);
                }
            }
        }
        return file_format;
    }

    public static FileInfo getFileInfo(String file_name, int file_format) {
        switch (file_format) {
            case 1: {
                return new FileInfoRaw(file_name);
            }
            case 2: {
                return new FileInfoPrg(file_name);
            }
            case 5: {
                return new FileInfoP00(file_name);
            }
            case 3: {
                return new FileInfoPcVic(file_name);
            }
            case 7: {
                return new FileInfoSid(file_name);
            }
        }
        return null;
    }

    static String getFileExtension(String file_name) {
        int dotPos = file_name.lastIndexOf(".");
        String extension = file_name.substring(dotPos + 1);
        return extension;
    }

    private static int checkRomFormat(File file) {
        if (file.length() % 256L == 2L) {
            return 2;
        }
        return 1;
    }

    private static boolean hasHeaderMagic(File file, byte[] magic) {
        boolean has_magic;
        block18: {
            has_magic = false;
            FileInputStream file_stream = null;
            try {
                try {
                    boolean magic_violated = false;
                    file_stream = new FileInputStream(file);
                    int i = 0;
                    while (i < magic.length) {
                        if (file_stream.read() != magic[i]) {
                            magic_violated = true;
                            break;
                        }
                        ++i;
                    }
                    has_magic = !magic_violated;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (file_stream == null) break block18;
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (file_stream == null) break block18;
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (file_stream != null) {
                    try {
                        file_stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return has_magic;
    }
}

